#ifndef BITMAP_H
#define BITMAP_H

#include "types.h"
#include "pixel.h"
#include <iostream>
using namespace std;

#define BITMAP_FILE			0x4D42
#define BITMAP_BIT_COUNT	24 

class Bitmap 
{
public:
	Bitmap();
	Bitmap(const char *);
	~Bitmap();

	bool loadBitmap(const char *);

	Pixel getPixel(int index)	const	{return myImageBuffer[index];}
	int getRed(Pixel pixel)		const	{return pixel.getRed();}
	int getGreen(Pixel pixel)	const	{return pixel.getGreen();}
	int getBlue(Pixel pixel)	const	{return pixel.getBlue();}
	int getAlpha(Pixel pixel)	const	{return pixel.getAlpha();}

	UInt16 getFileType()		const	{return myFileType;}
	UInt16 getBitCount()		const	{return myBitCount;}
	UInt32 getStartBuffer()		const	{return myStartBuffer;}
	UInt32 getWidth()			const	{return myWidth;}
	UInt32 getHeight()			const	{return myHeight;}
	UInt32 getCompressionType()	const	{return myCompressionType;}

	void setFileType(UInt16 newFileType)				{myFileType = newFileType;}
	void setBitCount(UInt16 newBitCount)				{myBitCount = newBitCount;}
	void setStartBuffer(UInt32 newStartBuffer)			{myStartBuffer = newStartBuffer;}
	void setWidth(UInt32 newWidth)						{myWidth = newWidth;}
	void setHeight(UInt32 newHeight)					{myHeight = newHeight;}
	void setCompressionType(UInt32 newCompressionType)	{myCompressionType = newCompressionType;}

private:
	UInt16 myFileType,
			 myBitCount;
	UInt32 myStartBuffer,
			 myWidth,
			 myHeight,
			 myCompressionType;
	Pixel * myImageBuffer;

};

#endif


